@extends('layout.master')
@section('content')

<main id="js-page-content" role="main" class="page-content">
    <div class="row">
        <div class="col-md-11">
            <div class="subheader">
                <h1 class="subheader-title">
                    <i class="subheader-icon fal fa-table"></i> Users
                    <small>
                        All your users are here
                    </small>
                </h1>
            </div>
        </div>
        <div class="col-md-1" align="center">
            <button type="button" class="btn btn-success waves-effect waves-themed" data-toggle="modal" data-target="#add-modal" ><i class="fa-2x ni ni-big-plus"></i></button>
        </div>
    </div>
    
    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>Records</h2>
                    <div class="panel-toolbar">
                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table Style</button>
                        <div class="dropdown-menu dropdown-menu-animated dropdown-menu-right position-absolute pos-top">
                            <button class="dropdown-item active" data-action="toggle" data-class="table-bordered" data-target="#dt-basic-example">Bordered Table</button>
                            <button class="dropdown-item" data-action="toggle" data-class="table-sm" data-target="#dt-basic-example">Smaller Table</button>
                            <button class="dropdown-item" data-action="toggle" data-class="table-dark" data-target="#dt-basic-example">Table Dark</button>
                            <button class="dropdown-item active" data-action="toggle" data-class="table-hover" data-target="#dt-basic-example">Table Hover</button>
                            <button class="dropdown-item active" data-action="toggle" data-class="table-stripe" data-target="#dt-basic-example">Table Stripped</button>
                            <div class="dropdown-divider m-0"></div>
                            
                        </div>
                    </div>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <!-- datatable start -->
                        <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <!--<th>CNIC</th>-->
                                    <th>Gender</th>
                                    <!--<th>Address</th>-->
                                    <th>Image</th>
                                    <th>Department</th>
                                    <th>Sub Department</th>
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 2 || Session::get('usertype') == 3)
                                    <th>Role</th>
                                    @else
                                    @endif
                                    <th>Account</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(count($agents) > 0)
                                @php $count = 1; @endphp
                                @foreach($agents as $row)
                                <tr>
                                    <td>{{ $count }}</td>
                                    <td>{{ $row['first_name'] }} {{ $row['last_name'] }}</td>
                                    <td>{{ $row['email'] }}</td>
                                    <td>{{ $row['phone'] }}</td>
                                    <!--<td>{{ $row['cnic'] }}</td>-->
                                    <td>{{ $row['gender'] }}</td>
                                    <!--<td>{{ $row['address'] }}</td>-->
                                    <td>
                                        @if($row['image'] != null)
                                        <img src="{{ asset('public/backend/img/users/') }}/{{ $row['image'] }}" class="agentimamges" width="30" height="30" title="{{ $row['first_name'] }} {{ $row['last_name'] }}" title="" data-toggle="tooltip" data-placement="top" title="" data-original-title="Tooltip on top">
                                        @else
                                        -
                                        @endif
                                    </td>
                                    <td>{{ $row['department'] }}</td>
                                    
                                    <td>
                                    @if($row['sub_department'] != "-")
                                        @if(count($row['sub_department']) > 0)
                                            @foreach($row['sub_department'] as $sub)
                                                @if(count($row['sub_department']) == 1)
                                                    {{ $sub->sub_department_name }}
                                                @else
                                                    {{ $sub->sub_department_name }} ,
                                                @endif
                                            @endforeach
                                        @else
                                        -
                                        @endif
                                    @else
                                    -
                                    @endif
                                    </td>
                                    
                                    
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 2 || Session::get('usertype') == 3)
                                    <td>{{ $row['usertype'] }}</td>
                                    @else
                                    @endif
                                    @if($row['is_deleted'] == "0")
                                    <td><h6><span class="badge badge-info p-2">Activate</span></h6></td>
                                    @else
                                    <td><h6><span class="badge badge-danger p-2">Deactivated</span></h6></td>
                                    @endif
                                    <td>
                                        <!--<button type="button" data-rowid="{{ $row['user_id'] }}" data-session="{{ Session::get('usertype') }}" data-session-id="{{ Session::get('id') }}" class="btn btn-info waves-effect waves-themed edit-user" data-toggle="modal" data-target="#edit-modal">-->
                                        <!--    <i class="ni ni-note"></i>-->
                                        <!--</button> |-->
                                    <a href="{{ route('account-redirection',$row['user_id']) }}" type="button" class="btn btn-primary waves-effect waves-themed" title="Go"><i class="ni ni-action-redo"></i></a>
                                    @if($row['is_deleted'] == "0")
                                        <button type="button" class="btn btn-danger waves-effect waves-themed btnSelect" data-action="delete" data-rowid="{{ $row['user_id'] }}" title="Deactivate"><i class="ni ni-lock"></i></button>
                                    @else
                                        <a href="{{ route('active_user',$row['user_id']) }}" class="btn btn-success" data-rowid="{{ $row['user_id'] }}" title="Activate"><i class="ni ni-lock-open"></i></a>
                                    @endif
                                    
                                    <a href={{ route('hard_delete_agents',$row['user_id']) }}">

                                    <button type="button" class="btn btn-danger" style="background-color: red;" id="delete_agent"  title="Delete">X</button>


                                </a>
                                    </td>
                                </tr>
                                @php $count++; @endphp
                                @endforeach
                                @else
                                    <!--<h4 align="center" class="no-record">No Record</h4>-->
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <!--<th>CNIC</th>-->
                                    <th>Gender</th>
                                    <!--<th>Address</th>-->
                                    <th>Image</th>
                                    <th>Department</th>
                                    <th>Sub Department</th>
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 2 || Session::get('usertype') == 3)
                                    <th>Role</th>
                                    @else
                                    @endif
                                    <th>Account</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<div class="modal fade" id="add-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success-900">
                <h4 class="modal-title">
                    Add Users
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('add_agents') }}" id="add-user-btn">
                    @csrf
                    <div class="row p-2">
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5><b>First Name :</b></h5>
                                <input type="text" name="first_name" class="form-control" id="add-first-name" onkeypress="return (event.charCode > 64 && event.charCode < 91) || (event.charCode > 96 && event.charCode < 123) || event.charCode == 32" required>
                                <p class="error-message" id="error-first-name">required</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5><b>Last Name :</b></h5>
                                <input type="text" name="last_name" class="form-control" id="add-last-name" onkeypress="return (event.charCode > 64 && event.charCode < 91) || (event.charCode > 96 && event.charCode < 123) || event.charCode == 32" >
                                <p class="error-message" id="error-last-name">required</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5><b>Email :</b></h5>
                                <input type="email" name="email" id="add-email" class="form-control" required>
                                <p class="error-message" id="error-email">required</p>
                            </div>
                        </div>
                        
                    </div>
                    <div class="row p-2">
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Phone :</b></h5>
                                <input type="text" maxlength="14" name="phone" id="add-phone" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" class="form-control" required>
                                <p class="error-message" id="error-phone">required</p>
                            </div>
                        </div>
                        <!--<div class="col-md-4">-->
                        <!--    <div class="form-group">-->
                        <!--        <h5><b>CNIC :</b></h5>-->
                        <!--        <input type="number" name="cnic" class="form-control">-->
                        <!--    </div>-->
                        <!--</div>-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Gender :</b></h5>
                                <select class="form-control" name="gender" id="add-gender" required>
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>
                                <p class="error-message" id="error-gender">required</p>
                            </div>
                        </div>
                    </div>
                    
                    @if(Session::get('usertype') == 1) <!-- Admin Condition -->
                    <div class="row p-2">
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Role :</b></h5>
                                <select class="form-control" name="usertype" id="add-user-type" required>
                                    <option value="">Select Role</option>
                                    @foreach($usertypes as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                <p class="error-message" id="error-user-type">required</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Department :</b></h5>
                                <select class="form-control" name="department" id="add-department-select" data-session="{{ Session::get('usertype') }}" data-session-id="{{ Session::get('id') }}" required>
                                    <option value="">Select Department</option>
                                    @foreach($departments as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                <p class="error-message" id="error-department">required</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row p-2" id="hods-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Head Of Department :</b></h5>
                                <select class="form-control" name="add_hod" id="add-hods-select" placeholder="Select HOD">
                                </select>
                            </div>
                        </div>
                    </div>  

                    <div class="row p-2" id="hods-sub-department-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Sub Department :</b></h5>
                                <select class="form-control" name="add_hod_sub_department" id="add-hods-sub-department-select" placeholder="Select HOD Department">
                                </select>
                            </div>
                        </div>
                    </div>  
                    <div class="row p-2" id="hods-managers-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Managers :</b></h5>
                                <select class="form-control" name="add_hod_managers" id="add-hods-managers-select" placeholder="Select HOD Manager">
                                </select>
                            </div>
                        </div>
                    </div>                    

                    <div class="row p-2" id="sub-department-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Sub Departments :</b></h5>
                                <select class="select2 form-control" name="add_sub_department[]" id="sub-department-select" multiple="multiple" placeholder="Select Sub Department">
                                    
                                </select>
                            </div>
                        </div>
                    </div>
                    @elseif(Session::get('usertype') == 3) <!-- HOD Condition -->
                    <div class="row p-2">
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Role :</b></h5>
                                <select class="form-control" name="usertype" id="add-user-type">
                                    <option value="">Select Role</option>
                                    @foreach($usertypes as $row)
                                    @if($row->id != 1 && $row->id != Session::get('usertype'))
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Department :</b></h5>
                                <select class="form-control" name="department" id="add-department-select" data-session="{{ Session::get('usertype') }}" data-session-id="{{ Session::get('id') }}">
                                    <option value="Select">Select Department</option>
                                    @foreach($departments as $row)
                                    @if($row->id == Session::get('department_id'))
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                     <div class="row p-2" id="hods-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Managers :</b></h5>
                                <select class="form-control" name="add_hod" id="add-hods-select" placeholder="Select Manager">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row p-2" id="hods-sub-department-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Sub Department :</b></h5>
                                <select class="form-control" name="add_hod_sub_department" id="add-hods-sub-department-select" placeholder="Select HOD Department">
                                </select>
                            </div>
                        </div>
                    </div>  
                    <div class="row p-2" id="hods-managers-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Managers :</b></h5>
                                <select class="form-control" name="add_hod_managers" id="add-hods-managers-select" placeholder="Select HOD Manager">
                                </select>
                            </div>
                        </div>
                    </div>                    

                    <div class="row p-2" id="sub-department-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Sub Departments :</b></h5>
                                <select class="form-control" name="add_sub_department" id="sub-department-select" placeholder="Select Sub Department">
                                    
                                </select>
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="row p-2">
                        <div class="col-md-12" align="center">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary" >Save</button>
                            </div>
                        </div>
                    </div>
                </form>
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info-900">
                <h4 class="modal-title">
                    Edit User
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('update_agents') }}">
                    @csrf
                    <div class="row p-2">
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5><b>First Name :</b></h5>
                                <input type="text" name="first_name" class="edit-first-name form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5><b>Last Name :</b></h5>
                                <input type="text" name="last_name" class="edit-last-name form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5><b>Email :</b></h5>
                                <input type="email" name="email" class="edit-email form-control">
                            </div>
                        </div>
                        
                    </div>
                    <div class="row p-2">
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Phone :</b></h5>
                                <input type="text" name="phone" class="edit-phone form-control">
                            </div>
                        </div>
                        <!--<div class="col-md-4">-->
                        <!--    <div class="form-group">-->
                        <!--        <h5><b>CNIC :</b></h5>-->
                        <!--        <input type="text" name="cnic" class="cnic form-control">-->
                        <!--    </div>-->
                        <!--</div>-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Gender :</b></h5>
                                <select class="form-control" name="gender" id="edit-gender">
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    @if(Session::get('usertype') == 1)
                    <div class="row p-2">
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Role :</b></h5>
                                <select class="form-control" name="usertype" id="edit-usertype">
                                    <option value="">Select Role</option>
                                    @foreach($usertypes as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <h5><b>Department :</b></h5>
                                <select class="form-control" name="department" id="edit-department">
                                    <option value="">Select Department</option>
                                    @foreach($departments as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                    </div>
                    
                    <div class="row p-2" id="edit-hods-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Head Of Department :</b></h5>
                                <select class="form-control" name="add_hod" id="edit-hods-select" placeholder="Select HOD">
                                </select>
                            </div>
                        </div>
                    </div>  

                    <div class="row p-2" id="edit-hods-sub-department-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Sub Department :</b></h5>
                                <select class="form-control" name="edit_hod_sub_department" id="edit-hods-sub-department-select" placeholder="Select HOD Department">
                                </select>
                            </div>
                        </div>
                    </div>  
                    <div class="row p-2" id="edit-hods-managers-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Managers :</b></h5>
                                <select class="form-control" name="add_hod_managers" id="edit-hods-managers-select" placeholder="Select HOD Manager">
                                </select>
                            </div>
                        </div>
                    </div>                    

                    <div class="row p-2" id="edit-sub-department-row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5><b>Sub Departments :</b></h5>
                                <select class="select2 form-control" name="edit_sub_department[]" id="edit-sub-department-select" multiple="multiple" placeholder="Select Sub Department">
                                    
                                </select>
                            </div>
                        </div>
                    </div>
                    <!--<div class="row p-2">-->
                    <!--    <div class="col-md-12">-->
                    <!--        <div class="form-group">-->
                    <!--            <h5><b>Account :</b></h5>-->
                    <!--            <select class="form-control" name="account_status" id="account-status">-->
                    <!--                <option value="0">Activate</option>-->
                    <!--                <option value="1">Deactivated</option>-->
                    <!--            </select>-->
                    <!--        </div>-->
                    <!--    </div>-->
                    <!--</div>-->
                    @endif
                    

                    <input type="hidden" name="leadid" class="leadid">
                    <div class="row p-2">
                        <div class="col-md-12" align="center">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="deletebrandModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-confirm modal-dialog-centered">
        <div class="modal-content">
            <!-- <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div> -->
            <div class="modal-body" align="center">
                <img src="{{ asset('public/assets/images/close.png') }}" width="70" height="70">
                <h4 class="modal-title" style="color: #636363; margin-top: 10px;">Are you sure?</h4>
                <p style="color: #999999">Do you really want to deactivate this records?</p>
                <form method="POST" action="{{ route('delete_agents') }}">
                    @csrf
                    <input type="hidden" name="deleteagentid" class="deletebrandid" id="deleteleadblastid">
                    <button type="submit" class="btn btn-danger">Yes</button>
                    <button type="button" class="btn btn-info" data-dismiss="modal">No</button>
                </form>
            </div>
            <!-- <div class="modal-footer" align="center">

            </div> -->
        </div>
    </div>
</div>

@endsection

@section('page_script')

<script>

    $(document).ready(function() {
        $("#add-user-btn").validate();
    });
    $(document).ready(function()
    {
        $('.select2').select2({
            placeholder: "Select Sub Department"
        });
        // initialize datatable
        $('#dt-basic-example').dataTable(
        {
            responsive: true,
            "order": [[ 0, "desc" ]]
        });

        // code to read selected table row cell data (values).
        $("#dt-basic-example").on('click','.btnSelect',function(){
            var rowid = $(this).data('rowid');
            $('.deletebrandid').val(rowid);
            $('#deletebrandModal').modal('show');
        });
    });

    
    
    // $(document).on('click','#add-user-btn',function(){
    //     var name = $('#add-first-name').val();
    //     var email = $('#add-email').val();
    //     var phone = $('#add-phone').val();
    //     var gender = $('#add-gender').val();
    //     var user_type = $('#add-user-type').val();
    //     var department = $('#add-department-select').val();
        
    //     var nameValidation = /^([a-zA-Z\x20]{1,30})$/;
    //     var emailValidation = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    //     var phoneValidation = /^[0-9]*$/;
        
    //     if(name == '' || name == null && email == '' || email == null && phone == '' || phone == null && gender == '' || gender == null && user_type == '' || user_type == null && department == '' || department == null){
    //             $('#add-first-name').css('border', '1px solid red');
    //             $('#error-first-name').css('display','block');
    //             $('#error-first-name').text('required');
                
    //             $('#add-email').css('border', '1px solid red');
    //             $('#error-email').css('display','block');
    //             $('#error-email').text('required');
                
    //             $('#add-phone').css('border', '1px solid red');
    //             $('#error-phone').css('display','block');
    //             $('#error-phone').text('required');
                
    //             $('#add-gender').css('border', '1px solid red');
    //             $('#error-gender').css('display','block');
    //             $('#error-gender').text('required');
                
    //             $('#add-user-type').css('border', '1px solid red');
    //             $('#error-user-type').css('display','block');
    //             $('#error-user-type').text('required');
                
    //             $('#add-department-select').css('border', '1px solid red');
    //             $('#error-department').css('display','block');
    //             $('#error-department').text('required');
                
                
    //         }else{
    //             if(!nameValidation.test(name)){
    //                 $('#add-first-name').css('border', '1px solid red');
    //                 $('#error-first-name').css('display','block');
    //                 $('#error-first-name').text('Please enter full name');
    //             }else{
                   
    //                 if(email == '' || email == null && phone == '' || phone == null && gender == '' || gender == null && user_type == '' || user_type == null && department == '' || department == null){
    //                     $('#add-first-name').css('border', '1px solid #e5e5e5');
    //                     $('#error-first-name').css('display','none');
    //                     $('#add-email').css('border', '1px solid red');
    //                     $('#error-email').css('display','block');
    //                     $('#error-email').text('Please enter correct email');
                        
    //                 }else{
    //                     $('#add-first-name').css('border', '1px solid #e5e5e5');
    //                     $('#error-first-name').css('display','none');
                        
    //                     if(!emailValidation.test(email)){
    //                         $('#add-email').css('border', '1px solid red');
    //                         $('#error-email').css('display','block');
    //                         $('#error-email').text('Please enter correct email');
    //                     }else{
    //                         if(phone == '' || phone == null && gender == '' || gender == null && user_type == '' || user_type == null && department == '' || department == null){
    //                             $('#add-email').css('border', '1px solid #e5e5e5');
    //                             $('#error-email').css('display','none');
    //                             $('#add-phone').css('border', '1px solid red');
    //                             $('#error-phone').css('display','block');
    //                             $('#error-phone').text('Please enter correct number limit 10');
                                
    //                         }else{
    //                             $('#add-email').css('border', '1px solid #e5e5e5');
    //                             $('#error-email').css('display','none');
                                
    //                             if(!phoneValidation.test(phone)){
    //                                 $('#add-phone').css('border', '1px solid red');
    //                                 $('#error-phone').css('display','block');
    //                                 $('#error-phone').text('Please enter correct number limit 10');
    //                             }else{
    //                                 $('#add-phone').css('border', '1px solid #e5e5e5');
    //                                 $('#error-phone').css('display','none');
                                    
    //                                 if(gender == '' || gender == null && user_type == '' || user_type == null && department == '' || department == null){
    //                                     $('#add-phone').css('border', '1px solid #e5e5e5');
    //                                     $('#error-phone').css('display','none');
    //                                     $('#add-gender').css('border', '1px solid red');
    //                                     $('#error-gender').css('display','block');
    //                                     $('#error-gender').text('required');
    //                                     $('#add-user-type').css('border', '1px solid red');
    //                                     $('#error-user-type').css('display','block');
    //                                     $('#error-user-type').text('required');
    //                                     $('#add-department-select').css('border', '1px solid red');
    //                                     $('#error-department').css('display','block');
    //                                     $('#error-department').text('required');
                                        
    //                                 }else{
    //                                     $('#add-gender').css('border', '1px solid #e5e5e5');
    //                                     $('#error-gender').css('display','none');
                                        
    //                                     if(user_type == '' || user_type == null && department == '' || department == null){
    //                                         $('#add-user-type').css('border', '1px solid red');
    //                                         $('#error-user-type').text('required');
    //                                         $('#error-user-type').css('display','block');
    //                                         $('#add-department-select').css('border', '1px solid red');
    //                                         $('#error-department').css('display','block');
    //                                         $('#error-department').text('required');
    //                                     }else{
    //                                         $('#add-user-type').css('border', '1px solid #e5e5e5');
    //                                         $('#error-user-type').css('display','none');
    //                                         if(department == '' || department == null){
    //                                             $('#add-department-select').css('border', '1px solid red');
    //                                             $('#error-department').css('display','block');
    //                                             $('#error-department').text('required');
    //                                         }else{
    //                                             $('#add-department-select').css('border', '1px solid #e5e5e5');
    //                                             $('#error-department').css('display','none');
    //                                             $(this).attr('type','submit');
    //                                         }
    //                                     }
                                        
    //                                 }
    //                             }
                                
    //                         }
    //                     }
    //                 }
    //             }
                
    //         }
        
    // });

</script>

@endsection